﻿var categoriesEditor = {
    datatable: null,
    dataInEdit: false,
    refreshDataTable: function () {
        this.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-categoriesTable").a4datatable({
            displayColumnSelector: false,
            displayLength: 5,
            ajaxAction: a4.getAction("GetCategories", controllerName, "Library"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id v-id" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Class": "v-name" }
            ],
            localizableTexts: { "All": resources.AllChanges, "Search": resources.SearchCategories },
            defaultSorting: "Name",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "edit", "Label": resources.Edit },
                { "Action": "delete", "Label": resources.Delete }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    categoriesEditor.deleteItems(ids);
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var rowSel = data.rowSelector.first();

                switch (action) {
                    case "edit":

                        if (!categoriesEditor.dataInEdit) {
                            categoriesEditor.dataInEdit = true;
                            categoriesEditor.editNameInline(rowSel, row.Id);
                        } else {
                            a4.showErrorMessage(resources.DataTableEditAlreadyActive);
                        }

                        break;
                    case "delete":
                        categoriesEditor.deleteItems(row.Id);
                        break;
                }
            }
        });
    },
    deleteItems: function (items) {
        var self = this;
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteCategoriesResources, function () {
            a4.callServerMethod(a4.getAction("DeleteCategoryItems", controllerName, "Library"), { categoryIds: items },
                function (result) {
                    self.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    editNameInline: function (row, catId) {
        var self = this;
        var cell = $("td.v-name", row);
        var initialValue = cell.html();

        var editorHtml = "<div style=\"height:42px;vertical-align: middle;\" class=\"inline-editor\">";
        editorHtml += "<input class=\"v-nameInput\" type=\"text\" value=\"" + initialValue + "\" style=\"width:200px !important;margin-top: 9px;\"/>";
        editorHtml += "<div class=\"button primary h-save button-save\" style=\"margin-left: 10px;\">" + resources.Save + "</div>";
        editorHtml += "<div class=\"link-button h-cancel button-cancel\" style=\"\">" + resources.Cancel + "</div>";
        editorHtml += "</div>";
        cell.html(editorHtml);

        //Cancel
        $(".h-cancel", cell).on("click", function () {
            cell.html(initialValue);
            categoriesEditor.dataInEdit = false;
        });

        //Save
        $(".h-save", cell).on("click", function () {
            var name = $(".v-nameInput", cell).val()

            if (categoriesEditor.validateNewCategoryName(name)) {
                a4.callServerMethod(a4.getAction("UpdateCategoryName", controllerName, "Library"), { categoryId: catId, name: name },
                    function (result) {
                        self.refreshDataTable();
                        categoriesEditor.dataInEdit = false;
                    },
                    function (error) {
                        cell.html(initialValue);
                        categoriesEditor.dataInEdit = false;
                        var message = eval("(" + error.responseText + ")").Message;
                        a4.showErrorMessage(message);
                    }
                );
            } else {
                a4.showErrorMessage(resources.NameRequired);
            }
        });
    },
    validateNewCategoryName: function (name) {
        return name.replace(/^\s+|\s+$/g, '') != "";
    },
    bindEvents: function () {
        var self = this;

        $(".h-addCategory").on("click", function () {
            var name = $("#v-newCategoryName").val();

            if (categoriesEditor.validateNewCategoryName(name)) {
                a4.callServerMethod(a4.getAction("CreateCategory", controllerName, "Library"), { name: name },
                function (result) {
                    self.refreshDataTable();
                    $("#v-newCategoryName").val("");
                });
            } else {
                a4.showErrorMessage(resources.NameRequired);
            }
        });
    }
}

$(document).ready(function () {
    categoriesEditor.initializeDataTable();
    categoriesEditor.bindEvents();
});